IO_8 neurowire master select(IO_1) kbaud(20) clockedge(+) IOByte;

IO_7 output bit DOSel1 = 0;

IO_6 output bit b0;
IO_1 output bit b1;

IO_2 input bit s0;
IO_3 input bit s1;
IO_4 input bit s2;

IO_0 output bit snd;             //     

IO_5 output bit RTCSel = 0;

char GlobalX,GlobalY;

void DO (unsigned char j)
{
	j = j & 0x7F;
   	io_out(IOByte,&j,8);
   	io_out(DOSel1,1);
   	io_out(DOSel1,0);
}

void WrCom(unsigned char c)
{
	unsigned char l,h;
	l = c & 0x0F;
	h = c >> 4;
	DO (~h);
	DO (~(h | 0x10));
	DO (~h);
	
	DO (~l);
	DO (~(l | 0x10));
	DO (~l);
//	delay(4);	
}

void WrCh(unsigned char c)     		//    
{
	unsigned char l,h;
	l = c & 0x0F;
	h = c >> 4;
	DO (~(h | 0x40));
	DO (~(h | 0x50));
	DO (~(h | 0x40));
	
	DO (~(l | 0x40));
	DO (~(l | 0x50));
	DO (~(l | 0x40));
	
	GlobalX ++;
//	delay(4);
}

void WrChar(unsigned char c)		//    
{

static far char decode[64] = {0x41,0xA0,0x42,0xA1,0xE0,0x45,0xA3,0xA4,        	//192..255
				   0xA5,0xA6,0x4B,0xA7,0x4D,0x48,0x4F,0xA8,			
				   0x50,0x43,0x54,0xA9,0xAA,0x58,0xE1,0xAB,			
				   0xAC,0xE2,0xAD,0xAE,0x62,0xAF,0xB0,0xB1,
				   0x61,0xB2,0xB3,0xB4,0xE3,0x65,0xB6,0xB7,
				   0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0x6F,0xBE,
				   0x70,0x63,0xBF,0x79,0xE4,0x78,0xE5,0xC0,
				   0xC1,0xE5,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7};		
	if (c >= 192) c = decode[c-192];

	WrCh(c);
}

char WrStr(char * s)			//  
{
	char * ss;
	char i;
	char j;
	static far char decode[23] = {0,1,2,3,4,5,6,7,8,9,0,0,0,0,0,0,0,        	//
				   10,11,12,13,14,15};	
	ss = s;
	i = 0;
	while (*ss > 0) { 
		if (*ss == '/') { 
			ss++; 
			j = decode[(*(++ss))-48]*16;
			j = j + decode[(*(++ss))-48];
			WrCh(j); 
		}
		else WrChar(*ss);
		++ss; ++i;
	}
	return(i);
}

void Sym01()
{
	WrCom (0x48);
	WrCh(0x06);	WrCh(0x09);	WrCh(0x09);	WrCh(0x06);	WrCh(0x00);	WrCh(0x00);	WrCh(0x00);	WrCh(0x00);
}

void Sym02()
{
	WrCom (0x50);
	WrCh(0x01);	WrCh(0x03);	WrCh(0x07);	WrCh(0x0F);	WrCh(0x07);	WrCh(0x03);	WrCh(0x01);	WrCh(0x00);
}

void initscr()				//  
{
	DO(~0x03);
	DO(~0x13);
	DO(~0x03);
	delay(10);

	DO(~0x02);
	DO(~0x12);
	DO(~0x02);
	delay(10);

	WrCom (0x28);	
	WrCom (0x28);	
	WrCom (0x0D);	
	WrCom (0x06);	
	
	WrCom (0x01);		  // Clear screen
	WrCom (0x02);
	
	Sym01();Sym02();
}

void GoToXY(char x,char y)	// x = 0..15,  y = 0..3    
{
	WrCom(0x80 + (y & 0x01)*64 + (y & 0x02)*8 + x);
	GlobalX = x;GlobalY = y;
//	WrCom(0x80 + 61);
}

void ClrScr()			//  
{
	WrCom (0x01);
}

void CursorOff()		//  
{
	WrCom (0x0C);
}

void CursorOn()             //  
{
	WrCom (0x0D);
}

void WrStrXY(char X, char Y, char * Text)
{
	GoToXY(X,Y); WrStr(Text);
}

void ClearEndStr()
{
	char i;
	for (i=GlobalX;i<=15;i++) WrCh(' ');
}

unsigned long RTCSendData(unsigned long d)
{
	unsigned long b;
	io_out(RTCSel,1);
	memcpy(&b,&d,2);
	io_out(IOByte,&b,16);
	io_out(RTCSel,0); 
	return(b); 
}

unsigned long ComSet(unsigned long m, unsigned int n)
{
	struct bcd dig;
	unsigned long i;
	memset(&dig,0,3);
	bin2bcd(n,&dig);
	i = RTCSendData(m * 256 + dig.d5 * 16 + dig.d6);
	memset(&dig,0,3);
	dig.d6 = i & 0x000F;
	dig.d5 = (i & 0x00F0) >> 4;
	return(bcd2bin(&dig)); 
}

void itoa(signed long val, char *str, char len)			//  Int  
{
	str[0] = val / 10000 + 48;
	str[1] = val % 10000 / 1000 + 48;
	str[2] = val % 1000/ 100 + 48;
	str[3] = val % 100 / 10 + 48;
	str[4] = val % 10 + 48;
	str[5] = 0;
	while (str[0] == '0' && str[len] != 0) memcpy(str,str+1,5);
}


unsigned long SetSecond(int n) { return(ComSet(0x80,n)); }
unsigned long SetMinute(int n) { return(ComSet(0x81,n)); }
unsigned long SetHour(int n)  { return(ComSet(0x82,n)); }
unsigned long SetDOW(int n) { return(ComSet(0x83,n)); }
unsigned long SetDay(int n) { return(ComSet(0x84,n)); }
unsigned long SetMonth(int n) { return(ComSet(0x85,n)); }

unsigned long SetYear(unsigned long n) 
{ 
   	if (n <= 2007) n = 07;
	else n = n-2000;
	return(ComSet(0x86,n)); 
}

unsigned long GetSecond() { return(ComSet(0x00,0)); }
unsigned long GetMinute() { return(ComSet(0x01,0)); }
unsigned long GetHour() {  return(ComSet(0x02,0)); }
unsigned long GetYear() { return(ComSet(0x06,0)+2000); }
unsigned long GetMonth() { return(ComSet(0x05,0)); }
unsigned long GetDay() {   return(ComSet(0x04,0)); }
unsigned long GetDOW() {   return(ComSet(0x03,0)); }

#define Key0 48
#define Key1 49
#define Key2 50
#define Key3 51
#define Key4 52
#define Key5 53
#define Key6 54
#define Key7 55
#define Key8 56
#define Key9 57
#define PointKey 10
#define KeyF 11
#define StartKey 12
#define StopKey 13
#define EnterKey 14
#define EscKey 15
#define UpKey 16
#define DnKey 17
#define RightKey 18
#define LeftKey 19
//#define RKS2 40 

#define None 0

char KeyCode = None;     //     
char nulstr[17] = "                ";
far char s80[20];

mtimer repeating KBTimer = 20;   // keyboard

when (timer_expires(KBTimer))
{
	static unsigned char KeyBoardLine = 0;
	static char KeyboardCounter;
    static char PrevKey;
	static unsigned long KeyBoardScan[4];
	static unsigned long KC;
	unsigned long KB;	

	KeyBoardLine++;
	KeyBoardLine = KeyBoardLine & 0x03;
    io_out(b0,KeyBoardLine & 0x01);	
    io_out(b1,KeyBoardLine >> 1);
    KeyBoardScan[KeyBoardLine] = ((io_in (s2)) << 2) + ((io_in(s1)) << 1) + io_in (s0);
	KB = KeyBoardScan[0]+KeyBoardScan[1]*6+KeyBoardScan[2]*31+KeyBoardScan[3]*156;

	if ((KB > 0) && (KeyboardCounter < 20)) KeyboardCounter++; 
	
	if ((KB > 0) && (KeyboardCounter > 2)) KC = KB;

	if ((KB == 0) || (KeyboardCounter == 20)) { KeyboardCounter = 0; KC = 0; }
	
	DO05 = KC;

	if (PrevKey == 0) {	
		if (KC == 1) KeyCode = Key4;//
		if (KC == 2) KeyCode = Key8;//
		if (KC == 3) KeyCode = KeyF;//
		if (KC == 4) KeyCode = StartKey;//
		if (KC == 5) KeyCode = EnterKey;//
		if (KC == 6) KeyCode = Key3;
		if (KC == 12) KeyCode = Key7;
		if (KC == 18) KeyCode = PointKey;
		if (KC == 24) KeyCode = UpKey;
		if (KC == 30) KeyCode = RightKey;
		if (KC == 31) KeyCode = Key2;//
		if (KC == 62) KeyCode = Key6;//
		if (KC == 93) KeyCode = Key0;//
		if (KC == 124) KeyCode = LeftKey;//
		if (KC == 155) KeyCode = DnKey;//
		if (KC == 156) KeyCode = Key1;
		if (KC == 312) KeyCode = Key5;
		if (KC == 468) KeyCode = Key9; 		
		if (KC == 624) KeyCode = StopKey;
		if (KC == 780) KeyCode = EscKey;
	}
	PrevKey = KC;
}