/*
   LR0101 - 8  

float_type* AI (int i)
      
i -    1  16

unsigned int DI (int i)
        
 0  1
i -    1  16

*/

IO_8 neurowire master select(IO_2) kbaud(20) IOByte;
IO_0 output bit UISel1 = 1;

#ifndef intref
char in_CR[2] = {0x60,0xC0};        //{0x60,0x40};
char nl[2] = {0x60,0x40};           //{0x00,0x40};
#else
char in_CR[2] = {0x60,0x80};
char nl[2] = {0x60,0x00};
#endif

#ifndef ref25
float_type fldiv = {0,0x42,1,0x48,0x0000} /* 100.0 */;
#else
float_type fldiv = {0,0x42,1,0x4c,0x999a} /* 102.3 */;
#endif

unsigned long UI (int i, int j) //
{
   unsigned long inpbuf;
   inpbuf = 0;
   in_CR[0]+=--i;
   io_out(UISel1,0);
   memcpy(&inpbuf,in_CR,2);
   in_CR[0]-=i;
   io_out(IOByte,&inpbuf,16);
   io_out(UISel1,1);
   io_out(UISel1,0);
   memcpy(&inpbuf,nl,2);
   io_out(IOByte,&inpbuf,16);
   io_out(UISel1,1);
   inpbuf >>= 6;
   return (inpbuf); 
}

float_type flbuf;

float_type* AI (int i)
{
    float_type fl01; 
    unsigned long ii;
    int j;
    j = 0;
    if ( i > 8 ) return ( &fl_zero );
    ii = UI (i,j);
    if (ii) {
       fl_from_ulong( ii , &fl01 );
       fl_div( &fl01, &fldiv, &flbuf );
    }
    else flbuf = fl_zero;
    return ( &flbuf );
}

unsigned int DI (int i)
{
   int j;
   j = 0;
   if (i>8) return (0);
   return (UI (i,j) > 200);
}

