IO_8 neurowire master select(IO_2) kbaud(20) clockedge(+) IOByte;

IO_0 output bit AOSel01 = 1;
IO_4 output bit AOSel02 = 1;

#ifdef _FLOAT

float_type mult = { 0, 67, 1, 76, 49152 };

void AO (unsigned long i, float_type * j)
{
   unsigned long inpbuf;
   float_type ff;
   
   if (i > 8) return;
   fl_mul(j,&mult,&ff);
   inpbuf = fl_to_ulong(&ff);
   inpbuf = (inpbuf < 4096) ? inpbuf : 4095;
   
   if (i > 4) {
      i -= 5;
      inpbuf = inpbuf | i << 14 | 4096;
      io_out(AOSel01,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel01,1);
   } else {
      i--;
      inpbuf = inpbuf | i << 14 | 4096;
      io_out(AOSel02,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel02,1);
   }
}

#else

void AO (unsigned long i, unsigned long j)  
{
   unsigned long inpbuf;
   
   if (i > 8) return;
   inpbuf = (j < 4096) ? j : 4095;
   
   if (i > 4) {
      i -= 5;
      inpbuf = inpbuf | i << 14 | 4096;
      io_out(AOSel01,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel01,1);
   } else {
      i--;
      inpbuf = inpbuf | i << 14 | 4096;
      io_out(AOSel02,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel02,1);
   }
}

#endif
