/*
   LR1101 - 16  

float_type* AI (int i)
      
i -    1  16

unsigned int DI (int i)
        
 0  1
i -    1  16
*/

IO_8 neurowire master select(IO_2) kbaud(20) clockedge(+) IOByte;
IO_0 output bit UISel1 = 1;
IO_1 output bit UISel2 = 1;

#ifndef intref
char in_CR[2] = {0x60,0xC0};        //{0x60,0x40};
char nl[2] = {0x60,0x40};           //{0x00,0x40};
#else
char in_CR[2] = {0x60,0x80};
char nl[2] = {0x60,0x00};
#endif

#ifndef ref25
float_type fldiv = {0,0x42,1,0x48,0x0000} /* 100.0 */;
#else
float_type fldiv = {0,0x42,1,0x4c,0x999a} /* 102.3 */;
#endif

unsigned long UI (unsigned int i,char a)
{
   unsigned long inpbuf;
   unsigned long l;
   int j;
   int k;
   j = 0;
   l = 0;
   if ( i > 8 ) { i -= 8; j = 1; }
   i--;
   in_CR[0] += i;
   
   memcpy(&inpbuf,in_CR,2);
   j ? io_out(UISel2,0) : io_out(UISel1,0);
   io_out(IOByte,&inpbuf,16);
   j ? io_out(UISel2,1) : io_out(UISel1,1);
   
   if (a) for (k = 0; k < 9; k++) {
      
      memcpy(&inpbuf,in_CR,2);  
      j ? io_out(UISel2,0) : io_out(UISel1,0);
      io_out(IOByte,&inpbuf,16);
      j ? io_out(UISel2,1) : io_out(UISel1,1);
      
      l += inpbuf >> 6;
   }
     
   memcpy(&inpbuf,nl,2);
   j ? io_out(UISel2,0) : io_out(UISel1,0);
   io_out(IOByte,&inpbuf,16);
   j ? io_out(UISel2,1) : io_out(UISel1,1);
   
   l += inpbuf >> 6;
   
   in_CR[0] -= i;
   
   return (l); 
}

#ifdef _FLOAT
float_type flbuf;

float_type * AI (int i)
{
    float_type fl01; 
    unsigned long ii;
//    int j;
    ii = UI (i,1);
    if (ii) {
       fl_from_ulong( ii , &fl01 );
       fl_div( &fl01, &fldiv, &flbuf );
    }
    else flbuf = fl_zero;
    return ( &flbuf );
}

#endif

unsigned int DI (int i)
{
   return (UI (i,0) > 200);
}

