/*
   LR0701 -   

unsigned long SetSecond(int n) { return(CommonSet(0x80,n)); }
     
n - 

unsigned long SetMinute(int n) { return(CommonSet(0x81,n)); }
     
n - 

unsigned long SetHour(int n)  { return(CommonSet(0x82,n)); }
     
n - 

unsigned long SetDOW(int n) { return(CommonSet(0x83,n)); }
      
n -  

unsigned long SetDay(int n) { return(CommonSet(0x84,n)); }
      
n -  

unsigned long SetMonth(int n) { return(CommonSet(0x85,n)); }
     
n - 

unsigned long SetYear(int n) { return(CommonSet(0x86,n)); }
     
n -    2000 


unsigned long GetSecond() { return(CommonSet(0x00,0)); }
   

unsigned long GetMinute() { return(CommonSet(0x01,0)); }
   

unsigned long GetHour() {  return(CommonSet(0x02,0)); }
   

unsigned long GetYear() { return(CommonSet(0x06,0)); }
      2000 

unsigned long GetMonth() { return(CommonSet(0x05,0)); }
    

unsigned long GetDay() {   return(CommonSet(0x04,0)); }
    

unsigned long GetDOW() {   return(CommonSet(0x03,0)); }
     

*/

IO_8 neurowire master select(IO_5) kbaud(20) clockedge(+) IOByte;
IO_0 output bit RTCSel = 0;
IO_3 output bit DOSel = 0;

unsigned long RTCSendData(unsigned long d)
{
   unsigned long b;
   io_out(RTCSel,1);
   memcpy(&b,&d,2);
   io_out(IOByte,&b,16);
   io_out(RTCSel,0); 
   return(b); 
}

unsigned long CommonSet(unsigned int m, unsigned int n)
{
   struct bcd dig;
   unsigned int i;
   memset(&dig,0,3);
   bin2bcd(n,&dig);
   i = RTCSendData(m*256+dig.d5*16+dig.d6);
   memset(&dig,0,3);
   dig.d6 = i & 0x000F;
   dig.d5 = (i & 0x00F0) >> 4;
   return(bcd2bin(&dig)); 
}

unsigned long SetSecond(int n) { return(CommonSet(0x80,n)); }
unsigned long SetMinute(int n) { return(CommonSet(0x81,n)); }
unsigned long SetHour(int n)  { return(CommonSet(0x82,n)); }
unsigned long SetDOW(int n) { return(CommonSet(0x83,n)); }
unsigned long SetDay(int n) { return(CommonSet(0x84,n)); }
unsigned long SetMonth(int n) { return(CommonSet(0x85,n)); }
unsigned long SetYear(int n) { return(CommonSet(0x86,n)); }

unsigned long GetSecond() { return(CommonSet(0x00,0)); }
unsigned long GetMinute() { return(CommonSet(0x01,0)); }
unsigned long GetHour() {  return(CommonSet(0x02,0)); }
unsigned long GetYear() { return(CommonSet(0x06,0)); }
unsigned long GetMonth() { return(CommonSet(0x05,0)); }
unsigned long GetDay() {   return(CommonSet(0x04,0)); }
unsigned long GetDOW() {   return(CommonSet(0x03,0)); }

unsigned int ibuf=0; 

void DO (unsigned int i,unsigned long j)
{
   unsigned int k;
   k = 1 << (8 - i);
   if (j == 0) ibuf = ibuf & (~k); else ibuf = ibuf | k;
   k = ibuf;
   io_out(IOByte,&k,8);
   io_out(DOSel,1);
   io_out(DOSel,0);
}
