/*
   LR2501 - 8  , 8  

void DO (unsigned char i, unsigned char j)
  
i -     1  8
j -   0 , 1 

void AO (unsigned long i,const float_type * j)
  
i -     1  8
j -         


*/


IO_8 neurowire master select(IO_2) kbaud(20) clockedge(+) IOByte;
IO_0 output bit DOSel1 = 0;

IO_1 output bit AOSel01 = 1;
IO_4 output bit AOSel02 = 1;

float_type mult = { 0, 67, 1, 76, 49152 };

unsigned char DOBuf = 0; 

void DO (unsigned char i, unsigned char j)       // i in [1..8]; j in [0,1]
{
   unsigned char k;
   k = 1 << (8 - i);
   DOBuf = (j == 0) ? DOBuf & (~k) : DOBuf | k;
   k = DOBuf;
   io_out(IOByte,&k,8);
   io_out(DOSel1,1);
   io_out(DOSel1,0);   
}

void AO (unsigned long i,const float_type * j)
{
   unsigned long inpbuf;
   float_type ff;
   
   if (i > 8) return;
   fl_mul(j,&mult,&ff);
   inpbuf = fl_to_ulong(&ff);
   if (inpbuf > 4095) inpbuf = 4095;
   
   if (i > 4) {
      i -= 4;
      inpbuf = inpbuf + (((i-1) * 4) + 1) * 4096;
      io_out(AOSel01,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel01,1);
   } else {
      inpbuf = inpbuf + (((i-1) * 4) + 1) * 4096;
      io_out(AOSel02,0);
      io_out(IOByte,&inpbuf,16);
      io_out(AOSel02,1);
   }
}
