#ifndef lr0101io
#define lr0101io

IO_8 neurowire master select(IO_2) kbaud(20) IOByte;
IO_0 output bit UISel = 0;

char in_CR[2]={0x60,0x80};
char nl[2]={0x60,0x00};

unsigned int ibuf=0; 

unsigned long LR0101UI (int i)
{
   unsigned long inpbuf;
   inpbuf = 0;
   in_CR[0]+=--i;
   io_out(UISel,0);
   memcpy(&inpbuf,in_CR,2);
   in_CR[0]-=i;
   io_out(IOByte,&inpbuf,16);
   io_out(UISel,1);
   io_out(UISel,0);
   memcpy(&inpbuf,nl,2);
   io_out(IOByte,&inpbuf,16);
   io_out(UISel,1);
   inpbuf >>= 6;
   return (inpbuf);
}

unsigned long LR0101AI (int i)
{
   return (LR0101UI (i));
}

signed int LR0101DI (int i)
{
   return (LR0101UI (i) > 200);
}

#endif
