#ifndef lr1101io
#define lr1101io

IO_8 neurowire master select(IO_2) kbaud(20) IOByte;
IO_0 output bit UISel1 = 1;
IO_1 output bit UISel2 = 1;

char in_CR[2]={0x60,0x80};
char nl[2]={0x60,0x00};

unsigned int ibuf=0; 

unsigned long LR1101UI (int i)
{
   unsigned long inpbuf;
   int j;
   j = 0;
   if ( i > 8 ) { i -= 8; j = 1; }
   inpbuf = 0;
   in_CR[0]+=--i;
   j ? io_out(UISel2,0) : io_out(UISel1,0);
   memcpy(&inpbuf,in_CR,2);
   in_CR[0]-=i;
   io_out(IOByte,&inpbuf,16);
   j ? io_out(UISel2,1) : io_out(UISel1,1);
   j ? io_out(UISel2,0) : io_out(UISel1,0);
   memcpy(&inpbuf,nl,2);
   io_out(IOByte,&inpbuf,16);
   j ? io_out(UISel2,1) : io_out(UISel1,1);
   inpbuf >>= 6;
   return (inpbuf); 
}

unsigned long LR1101AI (int i)
{
   return (LR1101UI (i));
}

signed int LR1101DI (int i)
{
   return (LR1101UI (i) > 200);
}



#endif
