#ifndef lr1201io
#define lr1201io

IO_8 neurowire master select(IO_2) kbaud(20) IOByte;
IO_0 output bit UISel = 1;
IO_1 output bit DOSel = 0;

char in_CR[2]={0x60,0x80};
char nl[2]={0x60,0x00};

unsigned int ibuf=0; 

unsigned long LR1201UI (int i)
{
   unsigned long inpbuf;
   inpbuf = 0;
   in_CR[0]+=--i;
   io_out(UISel,0);
   memcpy(&inpbuf,in_CR,2);
   in_CR[0]-=i;
   io_out(IOByte,&inpbuf,16);
   io_out(UISel,1);
   io_out(UISel,0);
   memcpy(&inpbuf,nl,2);
   io_out(IOByte,&inpbuf,16);
   io_out(UISel,1);
   inpbuf >>= 6;
   return (inpbuf);
}

unsigned long LR1201AI (int i)
{
   return (LR1201UI (i));
}

unsigned int LR1201DI (int i)
{
   return (LR1201UI (i) > 200);
}


void LR1201DO (unsigned char j, unsigned char i) 
{
   unsigned int k;
   k = 1 << (8 - i);
   if (j == 0) ibuf = ibuf & (~k); else ibuf = ibuf | k;
   k = ibuf;
   io_out(IOByte,&k,8);
   io_out(DOSel,1);
   io_out(DOSel,0);
}

#endif
