#ifndef lr2201io
#define lr2201io

IO_8 neurowire master select(IO_2) kbaud(10) IOByte;

IO_1 output bit DOSel1 = 0;
IO_0 output bit DOSel2 = 0;

unsigned char ibuf1=0; 
unsigned char ibuf2=0; 
#endif


#ifndef lr2201
#define lr2201

void LR2201DO ( unsigned char j, unsigned char i)       //  j in [0,1], i in [1..16]
{
   unsigned char k;
   if (i > 8) {  
      k = 1 << (16 - i);
	   ibuf2 = (j == 0) ? ibuf2 & (~k) : ibuf2 | k;
	   k = ibuf2;
   	io_out(IOByte,&k,8);
	   io_out(DOSel2,1);
   	io_out(DOSel2,0);
	}
	else {
	   k = 1 << (8 - i);
	   ibuf1 = (j == 0) ? ibuf1 & (~k) : ibuf1 | k;
	   k = ibuf1;
   	io_out(IOByte,&k,8);
      io_out(DOSel1,1);
      io_out(DOSel1,0);
   }
}

#endif
