#ifndef lr2501io
#define lr2501io

IO_8 neurowire master select(IO_2) kbaud(20) clockedge(+) IOByte;
IO_0 output bit DOSel1 = 0;

IO_1 output bit AOSel01 = 1;
IO_4 output bit AOSel02 = 1;

//float_type mult = { 0, 67, 1, 76, 49152 };

unsigned char DOBuf = 0; 

void LR2501DO (signed int j, unsigned char i)        
{
   unsigned char k;
   k = 1 << (8 - i);
   DOBuf = (j == 0) ? DOBuf & (~k) : DOBuf | k;
   k = DOBuf;
   io_out(IOByte,&k,8);
   io_out(DOSel1,1);
   io_out(DOSel1,0);
}

void LR2501AO (unsigned long j, unsigned long i)
{
   if (i > 8) return;
   if (j > 4095) j = 4095;
   
   if (i > 4) {
      i -= 5;
      j = j | i << 14 | 4096;
      io_out(AOSel01,0);
      io_out(IOByte,&j,16);
      io_out(AOSel01,1);
   } else {
      i -= 1;
      j = j | i << 14 | 4096;
      io_out(AOSel02,0);
      io_out(IOByte,&j,16);
      io_out(AOSel02,1);
   }
}

#endif