#ifndef lr5501io
#define lr5501io

IO_8 neurowire master select(IO_2) kbaud(20) clockedge(+) IOByte;

IO_0 output bit AOSel00 = 1;
IO_1 output bit AOSel01 = 1;
IO_4 output bit AOSel02 = 1;
IO_5 output bit AOSel03 = 1;

void LR5501AO (unsigned long ib, unsigned short ii)
{
   unsigned long i;
   i = ii;
   if (i > 16) return;
   if (ib > 4095) ib = 4095;
   switch (ii) {
   case 1:
   case 2:
   case 3:
   case 4: {
      i -= 1;
      ib = ib | i << 14 | 4096;
      io_out(AOSel02,0);
      io_out(IOByte,&ib,16);
      io_out(AOSel02,1);
      break;
   }
   case 5:
   case 6:
   case 7:
   case 8: {
      i -= 5;
      ib = ib | i << 14 | 4096;
      io_out(AOSel00,0);
      io_out(IOByte,&ib,16);
      io_out(AOSel00,1);
      break;
   }
   case 9:
   case 10:
   case 11:
   case 12: {
      i -= 9;
      ib = ib | i << 14 | 4096;
      io_out(AOSel03,0);
      io_out(IOByte,&ib,16);
      io_out(AOSel03,1);
      break;
   }
   case 13:
   case 14:
   case 15:
   case 16: {
      i -= 13;
      ib = ib | i << 14 | 4096;
      io_out(AOSel01,0);
      io_out(IOByte,&ib,16);
      io_out(AOSel01,1);
      break;
   }
}
}

#endif